/**
 * A simple object that provides a standard set of DHTML methods.
 *
 * @author <a href="mailto:james@jrc313.com">James Corbett</a>
 */
var Dhtml = 
{
	/**
	 * Get an element by it's ID.
	 *
	 * @param id {String} The ID of the element to be fetched
	 * @return A reference to the element. If the element cannot be found - null is returned
	 * @type HTMLDOMElement
	 */
	getElementById: function(id)
	{
		var element = null;
		
		if (document.getElementById)
		{
			return document.getElementById(id);
		}
		if (document.all)
		{
			return document.all[id];
		}
		
		return null;
	},
	
	/**
	 * Applies a style to an element.
	 *
	 * @param element {HTMLDOMElement|String} Either the ID of the element or the element itself
	 * @param styleName {String} Name of the style element that is to be set.
	 * @param styleValue {String} Value to be applied to the style element.
	 */
	setStyle: function(element, styleName, styleValue)
	{
		if (typeof(element) == "string")
		{
			element = this.getElementById(element);
		}
		
		if (element.style)
		{
			element.style[styleName] = styleValue;
		}
	},
	
	/**
	 * Change an elements class
	 *
	 * @param element {HTMLDOMElement|String} Either the ID of the element or the element itself
	 * @param className {String} Name of the class to be applied to the element
	 */
	setClass: function(element, className)
	{
		if (typeof(element) == "string")
		{
			element = this.getElementById(element);
		}
		
		if (element)
		{
			element.className = className;
		}
	},
	
	
	/**
	 * Hide an element. Sets the display style to none.
	 *
	 * @param element {HTMLDOMElement|String} Either the ID of the element that is to be hidden, or the element itself.
	 */
	hideElement: function(element)
	{
		this.setStyle(element, "display", "none");
	},
	
	/**
	 * Reveal an element. Sets the display style to block.
	 *
	 * @param element {HTMLDOMElement|String} Either the ID of the element that is to be revealed or the element itself.
	 */
	revealElement: function(element)
	{
		this.setStyle(element, "display", "block");
	},
	
	/**
	 * Fetch an array of elements that match the specified class.
	 *
	 * @param searchClass {String} The class to search for. Regular expression pattern matching is supported.
	 * @param parent {HTMLDOMElement|String} The node from which to perform the search. Can be the id of the node or the node itself.
	 * @param tag {String} Type of tag to include in the search.
	 */
	getElementsByClass: function(searchClass, parent, tag)
	{
		var classElements = new Array();
	
		if (typeof(node) == "string")
		{
			parent = this.getElementById(parent);
		}
		if (parent == null)
		{
			parent = document;
		}
		if (tag == null)
		{
			tag = '*';
		}
		var elements = parent.getElementsByTagName(tag);
		var elementCount = elements.length;
		var pattern = new RegExp("(^|\\s)" + searchClass + "(\\s|$)");
		for (i = 0, j = 0; i < elementCount; i++)
		{
			if (pattern.test(elements[i].className))
			{
				classElements[j] = elements[i];
				j++;
			}
		}
		return classElements;
	}
	
}